package gov.va.med.mhv.rxrefill.converter;

import java.util.HashSet;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.data.converter.PatientConverter;
import gov.va.med.mhv.rxrefill.data.model.PharmPatientChange;
import gov.va.med.mhv.rxrefill.data.model.PharmacyPatient;
import gov.va.med.mhv.rxrefill.dto.PharmPatientChangeDTO;
import gov.va.med.mhv.rxrefill.dto.PharmacyPatientDTO;

@Component
public class PharmacyPatientConverter {
	
	@Autowired
	private PatientConverter patientConverter;
	
	@Autowired
	private PharmPatientChangeConverter pharmPatientChangeConverter;
	
	public PharmacyPatientDTO convertDomainPharmacyPatient(PharmacyPatient pharmacyPatient){
		PharmacyPatientDTO pharmacyPatientDto = new PharmacyPatientDTO();
		
		pharmacyPatientDto.setId(pharmacyPatient.getId());
		pharmacyPatientDto.setOplock(pharmacyPatient.getOplock());
		pharmacyPatientDto.setPatientId(pharmacyPatient.getPatientId());
		
		// Adding patient to PharmacyPatientDTO is causing a recurring conversion of patient due to PharmPatient used in pharmacyPatientChange too..
		if (null != pharmacyPatient.getPatient()) {
			pharmacyPatientDto.setPatient(patientConverter.convertDomainPatient(pharmacyPatient.getPatient()));
		}

		if (null != pharmacyPatient.getPharmacyPatientChanges() && pharmacyPatient.getPharmacyPatientChanges().size() > 0) {
			Set<PharmPatientChangeDTO> pharmacyPatientChanges = new HashSet<PharmPatientChangeDTO>();
			for (PharmPatientChange pharmPatientChange : pharmacyPatient.getPharmacyPatientChanges()) {
				pharmacyPatientChanges.add(pharmPatientChangeConverter.convertDomainPharmPatientChange(pharmPatientChange));
			}
			pharmacyPatientDto.setPharmacyPatientChanges(pharmacyPatientChanges);
		}
		
		return pharmacyPatientDto;
	}
	
	
	public PharmacyPatient convertDTOPharmacyPatient(PharmacyPatientDTO pharmacyPatientDto){
		PharmacyPatient pharmacyPatient = new PharmacyPatient();
		
		pharmacyPatient.setId(pharmacyPatientDto.getId());
		pharmacyPatient.setOplock(pharmacyPatientDto.getOplock());
		pharmacyPatient.setPatientId(pharmacyPatientDto.getPatientId());
		
		if (null != pharmacyPatientDto.getPatient()) {
			pharmacyPatient.setPatient(patientConverter.convertDTOProfile(pharmacyPatientDto.getPatient()));
		}

		if (null != pharmacyPatientDto.getPharmacyPatientChanges() && pharmacyPatientDto.getPharmacyPatientChanges().size() > 0) {
			Set<PharmPatientChange> pharmacyPatientChanges = new HashSet<PharmPatientChange>();
			for (PharmPatientChangeDTO pharmPatientChange : pharmacyPatientDto.getPharmacyPatientChanges()) {
				pharmacyPatientChanges.add(pharmPatientChangeConverter.convertDTOPharmPatientChange(pharmPatientChange));
			}
			pharmacyPatient.setPharmacyPatientChanges(pharmacyPatientChanges);
		}
		
		return pharmacyPatient;
	}
}
